/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.parts.TitlePart;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialog<T> {
    public static final int POSITION_MOUSE = 0;
    public static final int POSITION_CENTER = 1;
    public static final int MONITOR_PRIMARY = 0;
    public static final int MONITOR_CURRENT = 1;
    protected I18N i18n = Application.getI18n();
    private List<Listener> listeners = new ArrayList<Listener>();
    private int pos = 1;
    private int height = -1;
    private int width = -1;
    private boolean resizable = false;
    private int monitor = 1;
    private Point cursor = null;
    private Shell shell;
    private Display display;
    private Composite parent;
    private TitlePart title;
    private Label imageLabel;
    private Image sideImage;
    private String titleText;
    private String panelText;
    private int closeState = 32;
    private Exception onEscapeException = null;

    public AbstractDialog(int position) {
        this(position, true);
    }

    public AbstractDialog(int position, boolean resizable) {
        this.pos = position;
        this.resizable = resizable;
    }

    protected boolean isModeless() {
        return false;
    }

    protected Shell createShell(Shell parent, int flags) {
        return new Shell(parent, flags);
    }

    private void init() {
        this.display = GUI.getDisplay();
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell rootShell = GUI.getShell();
                int modalType = 32768;
                if (rootShell.getData("systemshell") == null) {
                    modalType = 65536;
                }
                if (AbstractDialog.this.isModeless()) {
                    modalType = 0;
                }
                Logger.debug((String)("modal type: " + (modalType == 65536 ? "application" : (modalType == 32768 ? "primary" : "modeless"))));
                int flags = 0x860 | modalType;
                if (AbstractDialog.this.resizable) {
                    flags |= 0x10;
                }
                AbstractDialog.this.shell = AbstractDialog.this.createShell(rootShell, flags);
                AbstractDialog.this.shell.setLayout((Layout)SWTUtil.createGrid(1, false));
                AbstractDialog.this.shell.addListener(31, new Listener(){

                    public void handleEvent(Event e) {
                        if (e.detail == 2) {
                            e.doit = false;
                            try {
                                AbstractDialog.this.onEscape();
                            }
                            catch (Exception ex) {
                                AbstractDialog.this.onEscapeException = ex;
                            }
                        }
                    }
                });
                if (AbstractDialog.this.pos == 0) {
                    AbstractDialog.this.cursor = AbstractDialog.this.display.getCursorLocation();
                }
                AbstractDialog.this.title = new TitlePart(AbstractDialog.this.panelText != null ? AbstractDialog.this.panelText : AbstractDialog.this.titleText);
                AbstractDialog.this.title.paint((Composite)AbstractDialog.this.shell);
                Composite c = new Composite(AbstractDialog.this.title.getComposite(), 0);
                c.setLayoutData((Object)new GridData(1808));
                c.setLayout((Layout)SWTUtil.createGrid(2, false));
                if (AbstractDialog.this.sideImage != null) {
                    Composite cp = new Composite(c, 0);
                    cp.setLayoutData((Object)new GridData(2));
                    GridLayout gl1 = new GridLayout();
                    gl1.marginHeight = 8;
                    gl1.marginWidth = 8;
                    cp.setLayout((Layout)gl1);
                    AbstractDialog.this.imageLabel = new Label(cp, 0);
                    AbstractDialog.this.imageLabel.setLayoutData((Object)new GridData(1808));
                }
                AbstractDialog.this.parent = new Composite(c, 0);
                GridLayout parentLayout = new GridLayout();
                parentLayout.marginHeight = 2;
                parentLayout.marginWidth = 2;
                AbstractDialog.this.parent.setLayout((Layout)parentLayout);
                AbstractDialog.this.parent.setLayoutData((Object)new GridData(1808));
            }
        });
    }

    protected final void addShellListener(final ShellListener l) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDialog.this.shell.addShellListener(l);
            }
        });
    }

    protected final Display getDisplay() {
        return this.display;
    }

    protected final Shell getShell() {
        return this.shell;
    }

    public void addCloseListener(Listener l) {
        this.listeners.add(l);
    }

    public void setTitle(String title) {
        String string = this.titleText = title == null ? "" : title;
        if (this.shell != null && !this.shell.isDisposed()) {
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractDialog.this.shell.setText(AbstractDialog.this.titleText);
                }
            });
        }
        this.setPanelText(this.panelText);
    }

    public void setPanelText(String text) {
        this.panelText = text;
        if (this.title != null) {
            this.title.setTitle(this.panelText != null ? this.panelText : this.titleText);
        }
    }

    public void setMonitor(int monitor) {
        this.monitor = monitor;
    }

    public final void setSize(int width, int height) {
        if (width > 0) {
            this.width = width;
        }
        if (height > 0) {
            this.height = height;
        }
    }

    public final void setSideImage(Image image) {
        this.sideImage = image;
        if (this.imageLabel != null && !this.imageLabel.isDisposed()) {
            this.imageLabel.setImage(image);
        }
    }

    protected abstract void paint(Composite var1) throws Exception;

    protected abstract T getData() throws Exception;

    protected void onEscape() {
        throw new OperationCanceledException("dialog cancelled");
    }

    public final T open() throws Exception {
        try {
            this.closeState = 32;
            this.onEscapeException = null;
            this.init();
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractDialog.this.shell.setText(AbstractDialog.this.titleText == null ? "" : AbstractDialog.this.titleText);
                    if (AbstractDialog.this.sideImage != null && !AbstractDialog.this.sideImage.isDisposed() && AbstractDialog.this.imageLabel != null && !AbstractDialog.this.imageLabel.isDisposed()) {
                        AbstractDialog.this.imageLabel.setImage(AbstractDialog.this.sideImage);
                    }
                    try {
                        AbstractDialog.this.paint(AbstractDialog.this.parent);
                    }
                    catch (Throwable t) {
                        Logger.error((String)"error while painting dialog", (Throwable)t);
                        throw new RuntimeException(t);
                    }
                    if (AbstractDialog.this.height != -1 || AbstractDialog.this.width != -1) {
                        Logger.debug((String)("using custom dialog size: " + AbstractDialog.this.width + "x" + AbstractDialog.this.height));
                        AbstractDialog.this.shell.pack();
                        AbstractDialog.this.height = AbstractDialog.this.height == -1 ? AbstractDialog.this.shell.getBounds().height : AbstractDialog.this.height;
                        AbstractDialog.this.width = AbstractDialog.this.width == -1 ? AbstractDialog.this.shell.getBounds().width : AbstractDialog.this.width;
                        AbstractDialog.this.shell.setSize(AbstractDialog.this.width, AbstractDialog.this.height);
                    } else {
                        AbstractDialog.this.shell.pack();
                    }
                    Rectangle displayRect = null;
                    displayRect = AbstractDialog.this.monitor == 1 ? GUI.getShell().getMonitor().getBounds() : AbstractDialog.this.display.getPrimaryMonitor().getBounds();
                    Rectangle shellRect = AbstractDialog.this.shell.getBounds();
                    int x = displayRect.x + (displayRect.width - shellRect.width) / 2;
                    int y = displayRect.y + (displayRect.height - shellRect.height) / 2;
                    Point size = AbstractDialog.this.shell.getSize();
                    if (AbstractDialog.this.pos == 0 && AbstractDialog.this.cursor != null) {
                        x = AbstractDialog.this.cursor.x - size.x / 2;
                        y = AbstractDialog.this.cursor.y - size.y / 2;
                    }
                    if (x + size.x > displayRect.x + displayRect.width) {
                        x = displayRect.x + displayRect.width - size.x - 4;
                    }
                    if (y + size.y > displayRect.y + displayRect.height) {
                        y = displayRect.y + displayRect.height - size.y - 4;
                    }
                    AbstractDialog.this.shell.setLocation(x, y);
                    AbstractDialog.this.shell.open();
                    AbstractDialog.this.shell.forceActive();
                    while (AbstractDialog.this.shell != null && !AbstractDialog.this.shell.isDisposed() && AbstractDialog.this.onEscapeException == null) {
                        if (AbstractDialog.this.display.readAndDispatch()) continue;
                        AbstractDialog.this.display.sleep();
                    }
                }
            });
            if (this.onEscapeException != null) {
                throw this.onEscapeException;
            }
            T t = this.getData();
            return t;
        }
        catch (OperationCanceledException oce) {
            this.closeState = 256;
            throw oce;
        }
        catch (SWTException e) {
            Throwable t = e.getCause();
            if (t instanceof OperationCanceledException) {
                this.closeState = 256;
                throw (OperationCanceledException)t;
            }
            throw e;
        }
        finally {
            this.close();
        }
    }

    public final void close() {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        Logger.debug((String)"closing dialog");
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AbstractDialog.this.shell != null && !AbstractDialog.this.shell.isDisposed()) {
                        SWTUtil.disposeChildren((Composite)AbstractDialog.this.shell);
                        AbstractDialog.this.shell.dispose();
                        AbstractDialog.this.shell = null;
                        Logger.debug((String)"dialog closed");
                    }
                }
                catch (Throwable t) {
                    Logger.error((String)"error while closing dialog", (Throwable)t);
                }
            }
        });
        try {
            Logger.debug((String)"notifying listeners");
            Event e = new Event();
            e.detail = this.closeState;
            if (e.detail != 256) {
                e.data = this.getData();
            }
            for (Listener l : this.listeners) {
                l.handleEvent(e);
            }
        }
        catch (Exception e) {
            Logger.error((String)"error while notifying listeners", (Throwable)e);
        }
    }
}

